<?php
// Simple CSS cleaner: keeps first occurrence of each selector (top-level & inside @rules)
// Usage: php tools\clean-css.php css/style.css
if ($argc < 2) { echo "Usage: php clean-css.php path/to/style.css\n"; exit(1); }
$in = $argv[1];
if (!file_exists($in)) { echo "File not found: $in\n"; exit(1); }
$css = file_get_contents($in);

// Basic tokenizer / parser to preserve order and remove duplicate selector blocks (first wins)
function parse_blocks($txt) {
    $i=0; $n=strlen($txt); $out=[];
    while ($i<$n) {
        if (preg_match('/\s+/A', $txt, $m, 0, $i)) { $out[]=$m[0]; $i+=strlen($m[0]); continue; }
        if ($txt[$i]==='@') {
            if (preg_match('/@[^\\{;]+/A', $txt, $m, 0, $i)) {
                $pre=$m[0]; $i+=strlen($pre);
                if (isset($txt[$i]) && $txt[$i]===';') { $out[]=$pre.';'; $i++; continue; }
                if (isset($txt[$i]) && $txt[$i]==='{') {
                    // find matching brace
                    $start=$i; $depth=0; $j=$i;
                    while ($j<$n) {
                        if ($txt[$j]==='{') $depth++;
                        elseif ($txt[$j]==='}') { $depth--; if ($depth===0) { $j++; break; } }
                        $j++;
                    }
                    $block = substr($txt, $i, $j-$i);
                    $i=$j;
                    $out[]=['atrule'=>trim($pre),'block'=>$block];
                    continue;
                }
            }
        }
        $pos = strpos($txt, '{', $i);
        if ($pos === false) { $out[] = substr($txt,$i); break; }
        $selector = trim(substr($txt,$i,$pos-$i));
        $depth=0; $j=$pos;
        while ($j<$n) {
            if ($txt[$j]==='{') $depth++;
            elseif ($txt[$j]==='}') { $depth--; if ($depth===0) { $j++; break; } }
            $j++;
        }
        $body = substr($txt,$pos,$j-$pos);
        $i=$j;
        $out[]=['selector'=>$selector,'body'=>$body];
    }
    return $out;
}

function stringify_blocks($blocks) {
    $s='';
    foreach($blocks as $b) {
        if (is_string($b)) { $s.=$b; continue; }
        if (isset($b['atrule'])) {
            $inner = substr($b['block'],1,-1);
            $inner_blocks = parse_blocks($inner);
            // dedupe inner selectors (first occurrence wins)
            $seen = [];
            $clean_inner = [];
            foreach($inner_blocks as $ib) {
                if (is_string($ib)) { $clean_inner[]=$ib; continue; }
                if (isset($ib['selector'])) {
                    $norm = preg_replace('/\s+/', ' ', trim($ib['selector']));
                    if (isset($seen[$norm])) continue;
                    $seen[$norm]=true;
                    $clean_inner[]=$ib;
                } else $clean_inner[]=$ib;
            }
            $s .= $b['atrule'].'{'.stringify_blocks($clean_inner).'}';
        } elseif (isset($b['selector'])) {
            $s .= $b['selector'].' '.$b['body'];
        }
    }
    return $s;
}

// top-level: parse and remove duplicate selectors (keep first)
$blocks = parse_blocks($css);
$seen=[]; $clean=[];
foreach($blocks as $b){
    if (is_string($b)) { $clean[]=$b; continue; }
    if (isset($b['selector'])) {
        $sels = array_map('trim', explode(',', $b['selector']));
        $new = [];
        foreach($sels as $sel){
            $norm = preg_replace('/\s+/', ' ', $sel);
            if (!isset($seen[$norm])) { $seen[$norm]=true; $new[]=$sel; }
        }
        if (count($new)) { $b['selector']=implode(', ', $new); $clean[]=$b; }
    } else $clean[]=$b;
}

$clean_css = stringify_blocks($clean);
$outPath = dirname($in).DIRECTORY_SEPARATOR.basename($in,'.css').'.clean.css';
file_put_contents($outPath, $clean_css);
echo "Clean CSS written to: $outPath\nReview before replacing original file.\n";