<?php
include "config.php";
date_default_timezone_set('Asia/Jakarta');

// ambil data pasaran (tanpa kolom kode)
$sql = "SELECT id, nama, logo, jam_tutup, jam_result
        FROM pasaran
        ORDER BY STR_TO_DATE(jam_tutup, '%H:%i') ASC, nama ASC";
$res = $conn->query($sql);
$rows = [];
if ($res) { while($r = $res->fetch_assoc()) $rows[] = $r; }

// util format HH:MM dari input HH:MM atau HH:MM:SS
function fmt_time($t) {
  if (!$t) return "-";
  $t = trim($t);
  if ($t === '') return "-";
  if (preg_match('/^\d{1,2}:\d{2}$/', $t)) return $t;
  if (preg_match('/^\d{1,2}:\d{2}:\d{2}$/', $t)) return substr($t,0,5);
  $ts = strtotime($t);
  return $ts ? date('H:i', $ts) : "-";
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Info Pasaran</title>
  <?php include __DIR__ . '/partials/livedraw-modal.php'; ?>
  <?php include __DIR__ . '/partials/styles.php'; ?>
  <style>
    /* Tambahan styling khusus untuk Info Pasaran */
    .info-container {
      max-width: 1080px;
      margin: 0 auto;
      padding: 20px;
      box-sizing: border-box;
    }
    
    .info-title {
      text-align: center;
      font-size: 24px;
      font-weight: 800;
      color: #fff;
      margin-bottom: 12px;
      text-transform: uppercase;
    }
    
    .info-desc {
      text-align: center;
      color: #ffd79a;
      font-size: 16px;
      margin-bottom: 20px;
      max-width: 600px;
      margin-left: auto;
      margin-right: auto;
    }
    
    .table-container {
      border-radius: 10px;
      overflow: hidden;
      box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    
    .table-info {
      width: 100%;
      border-collapse: collapse;
    }
    
    .table-info th {
      background: var(--table-head-bg);
      color: #fff;
      padding: 12px 10px;
      text-align: center;
      font-weight: 700;
      text-transform: uppercase;
      font-size: 14px;
      letter-spacing: 0.5px;
    }
    
    .table-info td {
      padding: 12px 10px;
      text-align: center;
      border-bottom: 1px solid var(--table-border);
    }
    
    .table-info tr:last-child td {
      border-bottom: none;
    }
    
    .table-info tr:nth-child(even) {
      background: rgba(0,0,0,0.15);
    }
    
    .pasaran-logo {
      width: 40px;
      height: 40px;
      object-fit: cover;
      border-radius: 8px;
      margin: 0 auto;
      display: block;
      box-shadow: 0 2px 4px rgba(0,0,0,0.2);
    }
    
    .pasaran-name {
      font-weight: 800;
      color: #ffd37a;
      font-size: 16px;
    }
    
    /* Mobile responsive */
    @media (max-width: 768px) {
      .table-info thead {
        display: none;
      }
      
      .table-info tbody, 
      .table-info tr, 
      .table-info td {
        display: block;
        width: 100%;
      }
      
      .table-info tr {
        margin-bottom: 16px;
        border: 1px solid var(--table-border);
        border-radius: 10px;
        overflow: hidden;
      }
      
      .table-info td {
        display: flex;
        justify-content: space-between;
        align-items: center;
        text-align: right;
        padding: 12px 15px;
      }
      
      .table-info td:before {
        content: attr(data-label);
        font-weight: 700;
        color: #ffd79a;
        text-align: left;
      }
      
      .pasaran-logo {
        margin: 0;
      }
    }

    /* Perbaikan khusus untuk header tabel yang tidak diinginkan */
    @media (max-width: 767px) {
      /* Hapus semua header tabel tambahan yang tidak diinginkan */
      .table-info > tr:empty,
      .table-info thead + thead,
      .table-container > table + table,
      .table-container > div:not(.table-info),
      .table-container > table:empty {
        display: none !important;
      }
      
      /* Pastikan hanya ada satu thead yang ditampilkan */
      .table-info thead {
        display: none !important;
      }
      
      /* Tambahan: Perbaiki border dan spacing pada baris pertama */
      .table-info tbody tr:first-child td {
        border-top: none !important;
      }
      
      /* Perbaiki margin antar card pada mobile */
      .table-info tbody tr {
        margin-bottom: 12px !important;
        box-shadow: 0 2px 8px rgba(0,0,0,0.2) !important;
      }
    }
  </style>
</head>
<body class="page-info">
<?php include __DIR__ . '/partials/head.php'; ?>

<main>
  <div class="info-container">
    <h2 class="info-title">Informasi Pasaran</h2>
    <p class="info-desc">Daftar nama pasaran, jadwal tutup, jam result, dan keterangan frekuensi result.</p>

    <div class="table-container">
      <table class="table-info">
        <thead>
          <tr>
            <th>Logo</th>
            <th>Nama Pasaran</th>
            <th>Jam Tutup</th>
            <th>Jam Result</th>
            <th>Result Harian</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td data-label="Logo">
              <?php if (!empty($r['logo']) && file_exists("img/pasaran/".$r['logo'])): ?>
                <img src="img/pasaran/<?= htmlspecialchars($r['logo']) ?>" alt="logo" class="pasaran-logo">
              <?php else: ?>
                <span style="color:#94a3b8">-</span>
              <?php endif; ?>
            </td>
            <td data-label="Nama Pasaran" class="pasaran-name"><?= htmlspecialchars($r['nama']) ?></td>
            <td data-label="Jam Tutup"><strong><?= fmt_time($r['jam_tutup']).' WIB' ?></strong></td>
            <td data-label="Jam Result"><strong><?= fmt_time($r['jam_result']).' WIB' ?></strong></td>
            <td data-label="Result Harian"><span style="font-weight:700;color:#ffd37a;">SETIAP HARI</span></td>
          </tr>
        <?php endforeach; ?>
        <?php if (empty($rows)): ?>
          <tr><td colspan="5" style="text-align:center;color:#94a3b8;">Belum ada data pasaran.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</main>
<?php include __DIR__ . '/partials/footer.php'; ?>
<script>
  // Ganti kode di sekitar baris 745 dengan kode berikut:

  // Sebelum:
  document.getElementById('elementTidakAda').addEventListener('click', function() {
      // kode yang error
  });

  // Sesudah:
  var elementTarget = document.getElementById('elementTidakAda');
  if (elementTarget) { // Tambahkan pengecekan null
      elementTarget.addEventListener('click', function() {
          // kode yang sama
      });
  }
</script>
</body>
</html>