<?php
$year = date('Y');

// Gunakan function global dari config.php - SIMPLE!
$seo = get_seo_data();
?>
<style>
  .np-footer{background:#0b1320;color:#a7b0c0;margin-top:24px}
  .np-footer a{color:#cfd6e4;text-decoration:none}
  .np-footer a:hover{color:#ffffff}
  .np-footer .container{max-width:1200px;margin:0 auto;padding:28px 12px}

  /* Brand */
  .np-footer .brand-row{
    display:flex;flex-direction:column;align-items:center;text-align:center;gap:10px;margin-bottom:18px
  }
  .np-footer .brand-row .logo{display:flex;align-items:center;gap:10px}
  .np-footer .brand-row .logo .dot{width:10px;height:10px;background:#22c55e;border-radius:50%}
  .np-footer .social{display:flex;gap:10px;margin-top:6px}
  .np-footer .social a{
    display:inline-flex;align-items:center;justify-content:center;width:36px;height:36px;
    border:1px solid #233049;border-radius:8px
  }

  /* Kontak */
  .np-footer .contact-box{
    margin:10px auto 16px;max-width:720px;padding:0 8px;text-align:center
  }
  .np-footer .title{font-weight:700;color:#e5ecf7;margin:8px 0}
  .np-footer .contact-info{
    display:flex;gap:20px;justify-content:center;flex-wrap:wrap;margin-top:10px
  }
  .np-footer .contact-info span{
    display:flex;align-items:center;gap:8px;color:#cfd6e4
  }

  /* Bottom */
  .np-footer .bottom{
    border-top:1px solid #1b2434;margin-top:16px;padding:12px 0;color:#91a0b6;
    display:flex;justify-content:center
  }

  @media (max-width:600px){
    .np-footer .container{padding:22px 12px}
    .np-footer .contact-info{gap:12px;flex-direction:column}
  }
</style>

<footer class="np-footer" role="contentinfo">
  <div class="container">
    <div class="brand-row">
      <div class="logo">
        <div class="dot"></div>
        <div style="font-weight:800;color:#ffffff;font-size:18px;"><?= htmlspecialchars(strtoupper($seo['site_name'])) ?></div>
      </div>
      <div style="max-width:620px;line-height:1.6">
        <?= htmlspecialchars($seo['site_description']) ?>
      </div>
    </div>
    
    <!-- Contact Section - Gunakan data dari SEO settings -->
    <div class="contact-box">
      <div style="font-weight:bold;color:#ffd700;margin-bottom:10px;">Kontak</div>
      <div class="contact-info">
        <?php if (!empty($seo['contact_email'])): ?>
        <span>📧 <?= htmlspecialchars($seo['contact_email']) ?></span>
        <?php endif; ?>
        
        <?php if (!empty($seo['contact_phone'])): ?>
        <span>📞 <?= htmlspecialchars($seo['contact_phone']) ?></span>
        <?php endif; ?>
      </div>
    </div>

    <!-- Single Copyright - Gunakan site name dari SEO -->
    <div class="bottom">
      <div>© <?= $year ?> <?= htmlspecialchars($seo['site_name']) ?>. All rights reserved.</div>
    </div>
  </div>
</footer>

<script>
// Handle content loaded event
window.addEventListener('contentLoaded', function() {
    console.log('Content loaded - reinitializing components');
});

// MODIFY smooth-navigation.js untuk SKIP history links
if (typeof window.SmoothNavigation !== 'undefined') {
    // Override shouldPreventDefault to skip history links
    var original = window.SmoothNavigation.shouldPreventDefault;
    window.SmoothNavigation.shouldPreventDefault = function(link) {
        // Skip history links - let them be handled by history modal
        if (link.classList.contains('btn-history') || 
            link.hasAttribute('data-history') || 
            link.href.includes('history.php')) {
            console.log('Smooth navigation skipping history link:', link.href);
            return false;
        }
        return original ? original.call(this, link) : true;
    };
}
</script>

<!-- Load smooth navigation SETELAH override -->
<script src="/togel/assets/js/smooth-navigation.js"></script>

</body>
</html>