<?php
include_once __DIR__ . "/config.php";
date_default_timezone_set('Asia/Jakarta');
header('Content-Type: application/json');

// Parameter pasaran_id (opsional)
$pasaranId = isset($_GET['pasaran_id']) ? (int)$_GET['pasaran_id'] : 0;

// Ambil daftar pasaran
$pasaran = [];
$rs = $conn->query("SELECT id, nama, jam_tutup, jam_result, logo FROM pasaran ORDER BY jam_tutup ASC");
while ($r = $rs->fetch_assoc()) {
    $pasaran[] = [
        'id' => (int)$r['id'],
        'nama' => $r['nama'],
        'jam_tutup' => $r['jam_tutup'],
        'jam_result' => $r['jam_result'],
        'logo' => $r['logo']
    ];
}
$rs->close();

if (empty($pasaran)) {
    echo json_encode(['error' => 'Tidak ada pasaran.']);
    exit;
}

// Waktu sekarang
$now = new DateTime('now', new DateTimeZone('Asia/Jakarta'));
$today = $now->format('Y-m-d');

// Cari pasaran yang sedang berjalan
$activeIdx = 0;
// Jika pasaranId disediakan, cari pasaran tersebut
if ($pasaranId > 0) {
    foreach ($pasaran as $i => $p) {
        if ($p['id'] === $pasaranId) {
            $activeIdx = $i;
            break;
        }
    }
} else {
    // Logic untuk mencari pasaran aktif berdasarkan jam
    foreach ($pasaran as $i => $p) {
        $jamTutup = DateTime::createFromFormat('Y-m-d H:i:s', $today . ' ' . $p['jam_tutup']);
        if ($now < $jamTutup) {
            $activeIdx = ($i === 0) ? count($pasaran) - 1 : $i - 1;
            break;
        }
        // Jika sudah lewat semua, ambil pasaran terakhir hari ini
        if ($i === count($pasaran) - 1) $activeIdx = $i;
    }
}
$activePasaran = $pasaran[$activeIdx];

// Ambil jam result & jam tutup pasaran aktif
$jamTutup = DateTime::createFromFormat('Y-m-d H:i:s', $today . ' ' . $activePasaran['jam_tutup']);
$jamResult = DateTime::createFromFormat('Y-m-d H:i:s', $today . ' ' . $activePasaran['jam_result']);

// Ambil hasil prize dari DB
$prize = ['-', '-', '-'];
$sql = "SELECT prize, nomor FROM hasil WHERE pasaran_id = {$activePasaran['id']} AND DATE(tanggal) = '{$today}'";
$rs = $conn->query($sql);
while ($r = $rs->fetch_assoc()) {
    $idx = (int)$r['prize'] - 1;
    if ($idx >= 0 && $idx < 3) $prize[$idx] = $r['nomor'];
}
$rs->close();

// Logic tampil prize
$showPrize = [false, false, false];
$diffToResult = $now->getTimestamp() - $jamResult->getTimestamp();
if ($diffToResult >= 0) $showPrize[0] = true; // Prize 1: jam result
if ($now->getTimestamp() >= $jamResult->getTimestamp() - 60) $showPrize[1] = true; // Prize 2: 1 menit sebelum
if ($now->getTimestamp() >= $jamResult->getTimestamp() - 120) $showPrize[2] = true; // Prize 3: 2 menit sebelum

// Jika belum waktunya, prize tetap '-'
$displayPrize = [
    $showPrize[0] ? $prize[0] : '-',
    $showPrize[1] ? $prize[1] : '-',
    $showPrize[2] ? $prize[2] : '-'
];

// Jika waktu sekarang >= jam tutup, tampilkan pasaran aktif dengan strip (masih undi)
$sedangUndi = ($now >= $jamTutup && $now < $jamResult);

// Menghitung waktu hingga jam result
$timeToResult = $jamResult->getTimestamp() - $now->getTimestamp();
$timeToResult = max(0, $timeToResult);

// Siapkan response data
$response = [
    'pasaran' => [
        'id' => $activePasaran['id'],
        'nama' => $activePasaran['nama'],
        'jam_tutup' => $activePasaran['jam_tutup'],
        'jam_result' => $activePasaran['jam_result'],
        'logo' => $activePasaran['logo']
    ],
    'prizes' => $displayPrize,
    'sedang_undi' => $sedangUndi,
    'time_to_result' => $timeToResult,
    'server_time' => $now->format('Y-m-d H:i:s'),
    'should_show' => $showPrize
];

echo json_encode($response);