<?php
include "config.php";
date_default_timezone_set('Asia/Jakarta');

$pasaranQ = $conn->query("SELECT id,nama FROM pasaran ORDER BY nama ASC");

// default filter: 30 hari terakhir
$pasaran_id = isset($_GET['pasaran_id']) ? intval($_GET['pasaran_id']) : 0;
$start = $_GET['start'] ?? date('Y-m-d', strtotime('-30 days'));
$end = $_GET['end'] ?? date('Y-m-d');
$prize = isset($_GET['prize']) && in_array($_GET['prize'], ['1','2','3']) ? intval($_GET['prize']) : 0;
$agg = $_GET['agg'] ?? 'full'; // full, digit1..digit4, last2, last3, last_digit, digit_all

$start_dt = $start . ' 00:00:00';
$end_dt = $end . ' 23:59:59';

// AJAX endpoint for chart data
if (isset($_GET['ajax']) && $_GET['ajax'] === '1') {
    header('Content-Type: application/json; charset=utf-8');

    if ($pasaran_id <= 0) {
        echo json_encode(['error' => 'Pilih pasaran']); exit;
    }

    // digit_all: count every digit (0-9) across all positions
    if ($agg === 'digit_all') {
        if ($prize) {
            $stmt = $conn->prepare("SELECT nomor FROM hasil WHERE pasaran_id=? AND prize=? AND tanggal BETWEEN ? AND ?");
            $stmt->bind_param('iiss', $pasaran_id, $prize, $start_dt, $end_dt);
        } else {
            $stmt = $conn->prepare("SELECT nomor FROM hasil WHERE pasaran_id=? AND tanggal BETWEEN ? AND ?");
            $stmt->bind_param('iss', $pasaran_id, $start_dt, $end_dt);
        }
        $stmt->execute();
        $res = $stmt->get_result();
        $counts = array_fill(0, 10, 0);
        $total_digits = 0;
        while ($r = $res->fetch_assoc()) {
            $nom = (string)$r['nomor'];
            $chars = preg_split('//u', $nom, -1, PREG_SPLIT_NO_EMPTY);
            foreach ($chars as $ch) {
                if (ctype_digit($ch)) {
                    $d = intval($ch);
                    $counts[$d]++;
                    $total_digits++;
                }
            }
        }
        $stmt->close();

        $labels = array_map('strval', range(0, 9));
        $data_counts = $counts;
        $data_pct = [];
        for ($i = 0; $i <= 9; $i++) {
            $data_pct[] = $total_digits > 0 ? round($counts[$i] / $total_digits * 100, 2) : 0;
        }

        echo json_encode([
            'labels' => $labels,
            'data' => $data_pct,        // persen untuk chart
            'counts' => $data_counts,   // jumlah kemunculan tiap digit
            'total_digits' => $total_digits
        ]);
        exit;
    }

    // build SQL for other aggregations
    $sql = '';
    if ($agg === 'full') {
        $sql = "SELECT nomor AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND tanggal BETWEEN ? AND ? ";
        if ($prize) $sql = "SELECT nomor AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND prize=? AND tanggal BETWEEN ? AND ? ";
        $sql .= " GROUP BY nomor ORDER BY cnt DESC LIMIT 50";
    } elseif (preg_match('/^digit([1-4])$/', $agg, $m)) {
        $pos = intval($m[1]);
        $sql = "SELECT SUBSTRING(nomor,?,1) AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND tanggal BETWEEN ? AND ? ";
        if ($prize) $sql = "SELECT SUBSTRING(nomor,?,1) AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND prize=? AND tanggal BETWEEN ? AND ? ";
        $sql .= " GROUP BY k ORDER BY cnt DESC";
    } elseif ($agg === 'last2' || $agg === 'last3') {
        $len = $agg === 'last2' ? 2 : 3;
        $sql = "SELECT RIGHT(nomor,{$len}) AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND tanggal BETWEEN ? AND ? ";
        if ($prize) $sql = "SELECT RIGHT(nomor,{$len}) AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND prize=? AND tanggal BETWEEN ? AND ? ";
        $sql .= " GROUP BY k ORDER BY cnt DESC LIMIT 50";
    } else { // last_digit
        $sql = "SELECT RIGHT(nomor,1) AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND tanggal BETWEEN ? AND ? ";
        if ($prize) $sql = "SELECT RIGHT(nomor,1) AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND prize=? AND tanggal BETWEEN ? AND ? ";
        $sql .= " GROUP BY k ORDER BY k ASC";
    }

    // prepare & bind
    if (preg_match('/SUBSTRING/', $sql)) {
        // SUBSTRING with positional parameter first
        if ($prize) {
            $stmt = $conn->prepare($sql);
            $stmt->bind_param('iiiss', $pos, $pasaran_id, $prize, $start_dt, $end_dt);
        } else {
            $stmt = $conn->prepare($sql);
            $stmt->bind_param('iiss', $pos, $pasaran_id, $start_dt, $end_dt);
        }
    } else {
        if ($prize) {
            $stmt = $conn->prepare($sql);
            $stmt->bind_param('iiss', $pasaran_id, $prize, $start_dt, $end_dt);
        } else {
            $stmt = $conn->prepare($sql);
            $stmt->bind_param('iss', $pasaran_id, $start_dt, $end_dt);
        }
    }

    $stmt->execute();
    $res = $stmt->get_result();
    $labels = []; $data = [];
    while ($r = $res->fetch_assoc()) {
        $labels[] = (string)$r['k'];
        $data[] = (int)$r['cnt'];
    }
    $stmt->close();

    // normalize last_digit to 0..9
    if ($agg === 'last_digit') {
        $map = array_fill(0, 10, 0);
        foreach ($labels as $i => $lab) {
            $d = intval($lab) % 10;
            $map[$d] = $data[$i];
        }
        $labels = array_map('strval', range(0, 9));
        $data = array_values($map);
    }

    echo json_encode(['labels' => $labels, 'data' => $data]);
    exit;
}

// --- server-side (non-AJAX) rendering for table and initial chart trigger ---

$total = 0;
$rows = [];

if ($pasaran_id > 0) {
    // total records (for percent when agg != digit_all)
    if ($agg === 'digit_all') {
        // For digit_all, total should be total digits; compute below when building rows
        // We'll fetch nomor rows and compute counts
        if ($prize) {
            $stmt = $conn->prepare("SELECT nomor FROM hasil WHERE pasaran_id=? AND prize=? AND tanggal BETWEEN ? AND ?");
            $stmt->bind_param('iiss', $pasaran_id, $prize, $start_dt, $end_dt);
        } else {
            $stmt = $conn->prepare("SELECT nomor FROM hasil WHERE pasaran_id=? AND tanggal BETWEEN ? AND ?");
            $stmt->bind_param('iss', $pasaran_id, $start_dt, $end_dt);
        }
        $stmt->execute();
        $res = $stmt->get_result();
        $counts = array_fill(0, 10, 0);
        $total_digits = 0;
        while ($r = $res->fetch_assoc()) {
            $nom = (string)$r['nomor'];
            $chars = preg_split('//u', $nom, -1, PREG_SPLIT_NO_EMPTY);
            foreach ($chars as $ch) {
                if (ctype_digit($ch)) {
                    $d = intval($ch);
                    $counts[$d]++;
                    $total_digits++;
                }
            }
        }
        $stmt->close();
        $rows = [];
        for ($i = 0; $i <= 9; $i++) $rows[] = ['k' => strval($i), 'cnt' => $counts[$i]];
        $total = $total_digits;
    } else {
        // total records count
        if ($prize) {
            $stmt = $conn->prepare("SELECT COUNT(*) as jml FROM hasil WHERE pasaran_id=? AND prize=? AND tanggal BETWEEN ? AND ?");
            $stmt->bind_param("iiss", $pasaran_id, $prize, $start_dt, $end_dt);
        } else {
            $stmt = $conn->prepare("SELECT COUNT(*) as jml FROM hasil WHERE pasaran_id=? AND tanggal BETWEEN ? AND ?");
            $stmt->bind_param("iss", $pasaran_id, $start_dt, $end_dt);
        }
        $stmt->execute();
        $res = $stmt->get_result();
        $total = (int)($res->fetch_assoc()['jml'] ?? 0);
        $stmt->close();

        // build rows per aggregation (reuse similar SQL as AJAX but limit where appropriate)
        if ($agg === 'full') {
            $sql = "SELECT nomor AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND tanggal BETWEEN ? AND ? ";
            if ($prize) $sql = "SELECT nomor AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND prize=? AND tanggal BETWEEN ? AND ? ";
            $sql .= " GROUP BY nomor ORDER BY cnt DESC LIMIT 50";
        } elseif (preg_match('/^digit([1-4])$/', $agg, $m)) {
            $pos = intval($m[1]);
            $sql = "SELECT SUBSTRING(nomor,?,1) AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND tanggal BETWEEN ? AND ? ";
            if ($prize) $sql = "SELECT SUBSTRING(nomor,?,1) AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND prize=? AND tanggal BETWEEN ? AND ? ";
            $sql .= " GROUP BY k ORDER BY cnt DESC";
        } elseif ($agg === 'last2' || $agg === 'last3') {
            $len = $agg === 'last2' ? 2 : 3;
            $sql = "SELECT RIGHT(nomor,{$len}) AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND tanggal BETWEEN ? AND ? ";
            if ($prize) $sql = "SELECT RIGHT(nomor,{$len}) AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND prize=? AND tanggal BETWEEN ? AND ? ";
            $sql .= " GROUP BY k ORDER BY cnt DESC LIMIT 50";
        } else {
            $sql = "SELECT RIGHT(nomor,1) AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND tanggal BETWEEN ? AND ? ";
            if ($prize) $sql = "SELECT RIGHT(nomor,1) AS k, COUNT(*) AS cnt FROM hasil WHERE pasaran_id=? AND prize=? AND tanggal BETWEEN ? AND ? ";
            $sql .= " GROUP BY k ORDER BY k ASC";
        }

        if (preg_match('/SUBSTRING/', $sql)) {
            if ($prize) {
                $stmt = $conn->prepare($sql);
                $stmt->bind_param('iiiss', $pos, $pasaran_id, $prize, $start_dt, $end_dt);
            } else {
                $stmt = $conn->prepare($sql);
                $stmt->bind_param('iiss', $pos, $pasaran_id, $start_dt, $end_dt);
            }
        } else {
            if ($prize) {
                $stmt = $conn->prepare($sql);
                $stmt->bind_param('iiss', $pasaran_id, $prize, $start_dt, $end_dt);
            } else {
                $stmt = $conn->prepare($sql);
                $stmt->bind_param('iss', $pasaran_id, $start_dt, $end_dt);
            }
        }

        $stmt->execute();
        $res = $stmt->get_result();
        while ($r = $res->fetch_assoc()) $rows[] = $r;
        $stmt->close();

        if ($agg === 'last_digit') {
            $map = array_fill(0, 10, 0);
            foreach ($rows as $r) {
                $d = intval($r['k']) % 10;
                $map[$d] = (int)$r['cnt'];
            }
            $rows = [];
            for ($i = 0; $i <= 9; $i++) $rows[] = ['k' => strval($i), 'cnt' => $map[$i]];
        }
    }
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Statistik Angka - 4D Pools Asia</title>
<link rel="stylesheet" href="style_front.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<style>
.stat-table{width:100%;border-collapse:collapse;margin-top:12px}
.stat-table th,.stat-table td{border:1px solid #ddd;padding:8px;text-align:left}
.bar{height:14px;background:#1976d2;display:inline-block;border-radius:6px}
.controls{display:flex;gap:12px;align-items:center;margin-bottom:12px;flex-wrap:wrap}
</style>
</head>
<body>
<div class="wrap">
  <h2>Statistik Angka Per Pasaran</h2>

  <form method="get" class="controls" id="statForm">
    <label>Pasaran:
      <select name="pasaran_id" required>
        <option value="0">-- Pilih Pasaran --</option>
        <?php while($p = $pasaranQ->fetch_assoc()): ?>
          <option value="<?= intval($p['id'])?>" <?= $pasaran_id==intval($p['id']) ? 'selected' : '' ?>><?= htmlspecialchars($p['nama'])?></option>
        <?php endwhile; ?>
      </select>
    </label>

    <label>Start: <input type="date" name="start" value="<?= htmlspecialchars($start) ?>"></label>
    <label>End: <input type="date" name="end" value="<?= htmlspecialchars($end) ?>"></label>

    <label>Prize:
      <select name="prize">
        <option value="0" <?= $prize===0 ? 'selected' : '' ?>>Semua</option>
        <option value="1" <?= $prize===1 ? 'selected' : '' ?>>Prize 1</option>
        <option value="2" <?= $prize===2 ? 'selected' : '' ?>>Prize 2</option>
        <option value="3" <?= $prize===3 ? 'selected' : '' ?>>Prize 3</option>
      </select>
    </label>

    <label>Agregasi:
      <select name="agg">
        <option value="full" <?= $agg==='full' ? 'selected' : '' ?>>Full nomor</option>
        <option value="digit1" <?= $agg==='digit1' ? 'selected' : '' ?>>Digit posisi 1 (kiri)</option>
        <option value="digit2" <?= $agg==='digit2' ? 'selected' : '' ?>>Digit posisi 2</option>
        <option value="digit3" <?= $agg==='digit3' ? 'selected' : '' ?>>Digit posisi 3</option>
        <option value="digit4" <?= $agg==='digit4' ? 'selected' : '' ?>>Digit posisi 4 (kanan)</option>
        <option value="last2" <?= $agg==='last2' ? 'selected' : '' ?>>Last 2 digit</option>
        <option value="last3" <?= $agg==='last3' ? 'selected' : '' ?>>Last 3 digit</option>
        <option value="last_digit" <?= $agg==='last_digit' ? 'selected' : '' ?>>Digit terakhir (0-9)</option>
        <option value="digit_all" <?= $agg==='digit_all' ? 'selected' : '' ?>>All positions (0-9)</option>
      </select>
    </label>

    <button type="submit">Tampilkan</button>
    <a href="stats.php" style="margin-left:10px;">Reset</a>
  </form>

  <?php if ($pasaran_id==0): ?>
    <p>Pilih pasaran terlebih dahulu untuk melihat statistik.</p>
  <?php else: ?>
    <p>Total record dalam filter: <strong><?= number_format($total) ?></strong></p>

    <canvas id="statsChart" style="max-width:800px;margin-bottom:18px;"></canvas>

    <table class="stat-table">
      <thead>
        <tr><th>#</th><th>Key</th><th>Frekuensi</th><th>Persentase</th><th>Bar</th></tr>
      </thead>
      <tbody>
        <?php
        $i = 0;
        foreach ($rows as $r):
          $i++;
          $cnt = (int)$r['cnt'];
          $pct = $total>0 ? round($cnt / $total * 100, 2) : 0;
        ?>
        <tr>
          <td><?= $i ?></td>
          <td><?= htmlspecialchars($r['k']) ?></td>
          <td><?= $cnt ?></td>
          <td><?= $pct ?>%</td>
          <td><div class="bar" style="width:<?= ($pct>0? $pct:0) ?>%;"></div></td>
        </tr>
        <?php endforeach; ?>
        <?php if(empty($rows)): ?>
          <tr><td colspan="5">Tidak ada data untuk filter ini.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  <?php endif; ?>

</div>

<script>
function fetchChart(){
  const form = document.getElementById('statForm');
  const params = new URLSearchParams(new FormData(form));
  params.set('ajax','1');
  fetch('stats.php?'+params.toString())
    .then(r=>r.json())
    .then(json=>{
      if(json.error){ console.error(json.error); return; }
      const ctx = document.getElementById('statsChart').getContext('2d');
      if(window._statsChart) window._statsChart.destroy();
      // use percent data if provided, otherwise raw counts
      const useData = json.data || json.counts || [];
      window._statsChart = new Chart(ctx, {
        type:'bar',
        data:{
          labels: json.labels || [],
          datasets:[{
            label:'Frekuensi (%)',
            data: useData,
            backgroundColor:'rgba(25,118,210,0.8)'
          }]
        },
        options:{responsive:true,plugins:{legend:{display:false}}}
      });
    }).catch(err=>console.error(err));
}

document.getElementById('statForm').addEventListener('submit', function(e){
  // allow normal submit for table, but also fetch chart
  setTimeout(fetchChart,10);
});
window.addEventListener('load', function(){ if(<?= $pasaran_id>0 ? 'true' : 'false' ?>) fetchChart(); });
</script>

</body>
</html>