<?php
include __DIR__ . '/config.php';
date_default_timezone_set('Asia/Jakarta');

$pid     = isset($_GET['pasaran_id']) ? (int)$_GET['pasaran_id'] : 0;
$isEmbed = isset($_GET['embed']) && $_GET['embed'] == '1';
$page    = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if($page < 1) $page = 1;

$per_page = 10;
$offset = ($page - 1) * $per_page;

function get_hari_indonesia($date_str) {
    $day_names = [
        'Sunday' => 'Minggu', 'Monday' => 'Senin', 'Tuesday' => 'Selasa',
        'Wednesday' => 'Rabu', 'Thursday' => 'Kamis', 'Friday' => 'Jumat', 'Saturday' => 'Sabtu'
    ];
    return $day_names[date('l', strtotime($date_str))] ?? date('l', strtotime($date_str));
}

function indo_tgl_fallback($ymd){ 
    return date('d-m-Y', strtotime($ymd)); 
}

function safe_display($str) {
    if (empty($str) || $str === '-') return '-';
    return htmlspecialchars($str);
}

// 🔧 FUNGSI UNTUK CEK APAKAH RESULT BOLEH DITAMPILKAN
function is_result_allowed($pasaran_id, $result_date, $conn) {
    // Get jam_result dari tabel pasaran
    $stmt = $conn->prepare("SELECT jam_result FROM pasaran WHERE id = ?");
    $stmt->bind_param("i", $pasaran_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $pasaran = $result->fetch_assoc();
    $stmt->close();
    
    if (!$pasaran || empty($pasaran['jam_result'])) {
        // Jika tidak ada jam_result, default tidak boleh tampil hari ini
        return date('Y-m-d') > $result_date;
    }
    
    $jam_result = $pasaran['jam_result']; // Format: "17:30:00"
    $result_datetime = $result_date . ' ' . $jam_result;
    $current_datetime = date('Y-m-d H:i:s');
    
    // Result boleh ditampilkan jika waktu sekarang sudah lewat jam result
    return $current_datetime >= $result_datetime;
}

$pas = null;
if($pid > 0){
    $q = $conn->prepare("SELECT id, nama, jam_result FROM pasaran WHERE id = ?");
    $q->bind_param("i", $pid);
    $q->execute();
    $r = $q->get_result();
    $pas = $r->fetch_assoc();
    
    if($isEmbed) {
        ?><!doctype html><html lang="id"><head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>History <?=htmlspecialchars($pas['nama'])?></title>
        <style>
            body { margin: 0; padding: 0; overflow: hidden; background: transparent; color: #ffd79a; font-family: Arial, sans-serif; }
            .hwrap { padding: 10px 16px; margin: 0; max-width: 100%; box-sizing: border-box; height: calc(100vh - 20px); display: flex; flex-direction: column; }
            .htitle { color: #ffd700; text-align: center !important; margin: 0 0 5px; font-size: 22px; width: 100%; display: block; }
            .hmarket { color: #ffd700; font-size: 18px; text-align: center !important; margin-bottom: 10px; font-weight: bold; width: 100%; display: block; text-transform: uppercase; }
            .history-table-wrap { width: 100%; overflow-x: hidden; flex: 1; }
            .history-table { width: 100%; border-collapse: collapse; table-layout: fixed; margin-bottom: 10px; }
            .history-table th { background-color: rgba(58, 32, 12, 0.8); color: #ffd700; padding: 8px 6px; text-align: center; font-size: 14px; font-weight: bold; }
            .history-table td { padding: 8px 6px; text-align: center; border-bottom: 1px solid rgba(255,255,255,0.1); word-break: break-word; font-size: 14px; vertical-align: top; }
            .history-table tr:nth-child(odd) { background-color: rgba(0,0,0,0.3); }
            .history-table tr:nth-child(even) { background-color: rgba(0,0,0,0.2); }
            .history-table .hm-date { width: 35%; }
            .history-table .hm-p { width: 21.66%; }
            .hist-number { display: block; font-weight: bold; color: #ffd700; max-width: 100%; overflow: hidden; text-overflow: ellipsis; line-height: 1.3; word-wrap: break-word; white-space: normal; }
            .hist-pending { color: #ff6b6b; font-style: italic; font-size: 12px; }
            .periode { font-size: 12px; color: #ccc; margin-top: 2px; }
            .pager { display: flex; justify-content: space-between; align-items: center; margin-top: 15px; padding: 0 5px; }
            .btn { background-color: rgba(62, 42, 14, 0.8); color: #ffd700; border: none; border-radius: 4px; padding: 8px 15px; cursor: pointer; text-decoration: none; font-size: 14px; transition: background-color 0.2s; }
            .btn:disabled, .btn.disabled { opacity: 0.5; cursor: not-allowed; }
            .btn:hover:not(:disabled):not(.disabled) { background-color: rgba(94, 74, 46, 0.9); }
            .text-center { text-align: center; }
            .page-info { font-size: 14px; color: #ffd79a; text-align: center; }
            .no-data { color: #999; font-style: italic; padding: 20px; }
            .result-info { font-size: 11px; color: #ccc; margin-top: 10px; text-align: center; }
        </style>
        </head><body>
        <div class="hwrap">
            <h1 class="htitle">History Pasaran</h1>
            <div class="hmarket"><?=htmlspecialchars($pas['nama'])?></div>
            
            <?php if (!empty($pas['jam_result'])): ?>
            <div class="result-info">
                Result keluar setiap hari jam <?=date('H:i', strtotime($pas['jam_result']))?>
            </div>
            <?php endif; ?>
            
            <div class="history-table-wrap">
                <table class="history-table">
                    <thead>
                        <tr>
                            <th class="hm-date">Hari, Tanggal</th>
                            <th class="hm-p">Prize 1</th>
                            <th class="hm-p">Prize 2</th>
                            <th class="hm-p">Prize 3</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                    // Query dengan filter waktu
                    $query = "
                        SELECT 
                            DATE(h.tanggal) as tgl,
                            h.tanggal,
                            (SELECT nomor FROM hasil h1 WHERE h1.pasaran_id = $pid AND DATE(h1.tanggal) = DATE(h.tanggal) AND h1.prize = 1 ORDER BY h1.id DESC LIMIT 1) as prize1,
                            (SELECT nomor FROM hasil h2 WHERE h2.pasaran_id = $pid AND DATE(h2.tanggal) = DATE(h.tanggal) AND h2.prize = 2 ORDER BY h2.id DESC LIMIT 1) as prize2,
                            (SELECT nomor FROM hasil h3 WHERE h3.pasaran_id = $pid AND DATE(h3.tanggal) = DATE(h.tanggal) AND h3.prize = 3 ORDER BY h3.id DESC LIMIT 1) as prize3
                        FROM hasil h
                        WHERE h.pasaran_id = $pid
                        GROUP BY DATE(h.tanggal)
                        ORDER BY DATE(h.tanggal) DESC
                    ";
                    
                    $result = $conn->query($query);
                    $clean_data = [];
                    
                    if ($result && $result->num_rows > 0) {
                        while($row = $result->fetch_assoc()) {
                            $date_key = $row['tgl'];
                            
                            // 🔒 CEK APAKAH RESULT BOLEH DITAMPILKAN
                            $show_result = is_result_allowed($pid, $row['tgl'], $conn);
                            
                            if (!isset($clean_data[$date_key])) {
                                $clean_data[$date_key] = [
                                    'tgl' => $row['tgl'],
                                    'tanggal' => $row['tanggal'],
                                    'prize1' => $show_result ? ($row['prize1'] ?? '-') : 'Belum Waktunya',
                                    'prize2' => $show_result ? ($row['prize2'] ?? '-') : 'Belum Waktunya',
                                    'prize3' => $show_result ? ($row['prize3'] ?? '-') : 'Belum Waktunya',
                                    'show_result' => $show_result
                                ];
                            }
                        }
                    }
                    
                    // Pagination
                    $total_records = count($clean_data);
                    $total_pages = ceil($total_records / $per_page);
                    
                    if ($page > $total_pages && $total_pages > 0) {
                        $page = $total_pages;
                        $offset = ($page - 1) * $per_page;
                        if ($offset < 0) $offset = 0;
                    }
                    
                    $paged_data = array_slice($clean_data, $offset, $per_page, true);
                    
                    // Display dengan time-based filtering
                    if(!empty($paged_data)) {
                        foreach($paged_data as $date => $data) {
                            $hari = get_hari_indonesia($data['tanggal']);
                            $tanggal = indo_tgl_fallback($data['tgl']);
                            ?>
                            <tr>
                                <td class="hm-date">
                                    <?=$hari?>, <?=$tanggal?>
                                </td>
                                <td class="hm-p">
                                    <?php if ($data['show_result']): ?>
                                        <span class="hist-number"><?=safe_display($data['prize1'])?></span>
                                    <?php else: ?>
                                        <span class="hist-pending">Belum Waktunya</span>
                                    <?php endif; ?>
                                </td>
                                <td class="hm-p">
                                    <?php if ($data['show_result']): ?>
                                        <span class="hist-number"><?=safe_display($data['prize2'])?></span>
                                    <?php else: ?>
                                        <span class="hist-pending">Belum Waktunya</span>
                                    <?php endif; ?>
                                </td>
                                <td class="hm-p">
                                    <?php if ($data['show_result']): ?>
                                        <span class="hist-number"><?=safe_display($data['prize3'])?></span>
                                    <?php else: ?>
                                        <span class="hist-pending">Belum Waktunya</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php
                        }
                    } else {
                        echo '<tr><td colspan="4" class="text-center no-data">Belum ada data history untuk pasaran ini</td></tr>';
                    }
                    ?>
                    </tbody>
                </table>
                
                <?php if ($total_pages > 1): ?>
                <div class="pager">
                    <?php 
                        $url_base = "history.php?pasaran_id=$pid&embed=1";
                        $prev_disabled = ($page <= 1) ? 'disabled' : '';
                        $prev_url = ($page > 1) ? "$url_base&page=" . ($page - 1) : '#';
                        $next_disabled = ($page >= $total_pages) ? 'disabled' : '';
                        $next_url = ($page < $total_pages) ? "$url_base&page=" . ($page + 1) : '#';
                    ?>
                    <a href="<?=$prev_url?>" class="btn <?=$prev_disabled?>" <?=$prev_disabled ? 'tabindex="-1" aria-disabled="true"' : ''?>>← Sebelumnya</a>
                    <span class="page-info">Hal <?=$page?> dari <?=$total_pages?></span>
                    <a href="<?=$next_url?>" class="btn <?=$next_disabled?>" <?=$next_disabled ? 'tabindex="-1" aria-disabled="true"' : ''?>>Selanjutnya →</a>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.pager a').forEach(function(link) {
                link.addEventListener('click', function(e) {
                    if (!this.classList.contains('disabled')) {
                        e.preventDefault();
                        window.location.href = this.getAttribute('href');
                    }
                });
            });
            
            if (window.parent && window.parent.postMessage) {
                window.parent.postMessage({
                    type: 'historyLoaded',
                    height: document.body.scrollHeight
                }, '*');
            }
        });
        </script>
        </body></html>
        <?php
        exit;
    }
}

?><!doctype html><html lang="id"><head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
  <title>History</title>
  <link rel="stylesheet" href="/togel/assets/css/main.css">
  <link rel="stylesheet" href="/togel/assets/css/history.css">
</head><body>
  <div class="content" style="max-width:860px;margin:20px auto;padding:0 12px">
    <h2>History</h2>
    <p>Buka dari tombol History pada kartu pasaran.</p>
  </div>
</body>
</html>