<?php
// Pastikan form pakai method POST, enctype="multipart/form-data", input name="logo"
include __DIR__ . '/../config.php';

function slugify_name($name){
  $name = trim((string)$name);
  if ($name === '') return '';
  if (function_exists('iconv')) {
    $tmp = @iconv('UTF-8','ASCII//TRANSLIT',$name);
    if ($tmp !== false) $name = $tmp;
  }
  $slug = strtolower(preg_replace('~[^a-z0-9]+~','-', $name));
  return trim($slug, '-');
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  exit('Method Not Allowed');
}

$namaPasaran = trim($_POST['nama_pasaran'] ?? '');
$idPasaran   = $_POST['id_pasaran'] ?? null; // opsional jika mau update DB by ID

if ($namaPasaran === '') {
  http_response_code(400);
  exit('Nama pasaran wajib diisi.');
}
if (!isset($_FILES['logo']) || $_FILES['logo']['error'] !== UPLOAD_ERR_OK) {
  http_response_code(400);
  exit('File logo tidak ditemukan atau gagal diupload.');
}

$slug  = slugify_name($namaPasaran);
$dir   = __DIR__ . '/../img/pasaran';
@mkdir($dir, 0777, true);

$allowed = ['png','jpg','jpeg','webp','gif'];
$orig    = $_FILES['logo']['name'];
$ext     = strtolower(pathinfo($orig, PATHINFO_EXTENSION));
if (!in_array($ext, $allowed)) {
  http_response_code(400);
  exit('Ekstensi tidak didukung. Gunakan: ' . implode(', ', $allowed));
}

// Tentukan nama file akhir -> slug.ext
$targetName = $slug . '.' . $ext;
$targetPath = $dir . '/' . $targetName;

// (Opsional) Hapus file lama dengan nama slug.* agar bersih
foreach (glob($dir . '/' . $slug . '.*') as $old) {
  @unlink($old);
}

// Pindahkan upload
$tmp = $_FILES['logo']['tmp_name'];
if (!is_uploaded_file($tmp) || !move_uploaded_file($tmp, $targetPath)) {
  http_response_code(500);
  exit('Gagal menyimpan file.');
}

// Update DB (opsional, sesuaikan nama tabel/kolom Anda)
if ($idPasaran !== null) {
  // Contoh: tabel pasaran(id, nama, logo)
  $pdo = $pdo ?? null; // jika pakai PDO di config.php
  if ($pdo instanceof PDO) {
    $stmt = $pdo->prepare('UPDATE pasaran SET nama = ?, logo = ? WHERE id = ?');
    $stmt->execute([$namaPasaran, $targetName, $idPasaran]);
  } else {
    // Jika pakai mysqli, sesuaikan di sini
  }
}

// Cache buster
$v = @filemtime($targetPath) ?: time();
$publicUrl = '../img/pasaran/' . rawurlencode($targetName) . '?v=' . $v;

// Output sederhana
header('Content-Type: application/json');
echo json_encode([
  'ok' => true,
  'nama' => $namaPasaran,
  'slug' => $slug,
  'file' => $targetName,
  'url'  => $publicUrl,
]);