<?php
// Tentukan halaman aktif berdasarkan nama file
$current_page = basename($_SERVER['PHP_SELF'], '.php');

// Cek apakah user adalah master
$is_master = ($_SESSION['role'] ?? '') === 'master';
?>

<!-- Sidebar Navigation -->
<div class="admin-sidebar">
  <div class="sidebar-header">
    <h3>Admin Panel</h3>
    <div class="user-info">
      <small><?= htmlspecialchars($_SESSION['username'] ?? 'Admin') ?></small>
      <small class="role-badge <?= $is_master ? 'master' : 'staff' ?>"><?= $is_master ? 'Master' : 'Staff' ?></small>
    </div>
  </div>
  
  <div class="sidebar-search">
    <input type="text" placeholder="Search..." class="search-input">
    <button type="button" class="search-btn">🔍</button>
  </div>
  
  <nav class="sidebar-menu">
    <!-- Dashboard - Semua role bisa akses -->
    <a href="dashboard.php" class="menu-item <?= $current_page === 'dashboard' ? 'active' : '' ?>">
      <span class="menu-icon">📊</span>
      <span class="menu-text">Dashboard</span>
    </a>
    
    <!-- Master-only menus -->
    <?php if ($is_master): ?>
    <a href="admin_pasaran.php" class="menu-item <?= $current_page === 'admin_pasaran' ? 'active' : '' ?>">
      <span class="menu-icon">🏆</span>
      <span class="menu-text">Admin Pasaran</span>
    </a>
    
    <a href="admin_users.php" class="menu-item <?= $current_page === 'admin_users' ? 'active' : '' ?>">
      <span class="menu-icon">👥</span>
      <span class="menu-text">Admin Users</span>
    </a>
    
    <a href="admin_permissions.php" class="menu-item <?= $current_page === 'admin_permissions' ? 'active' : '' ?>">
      <span class="menu-icon">🔐</span>
      <span class="menu-text">Set Permissions</span>
    </a>
    
    <a href="admin_seo.php" class="menu-item <?= $current_page === 'admin_seo' ? 'active' : '' ?>">
      <span class="menu-icon">🔍</span>
      <span class="menu-text">SEO Settings</span>
    </a>
    
    <!-- Master juga melihat Catatan Log -->
    <a href="admin_log.php" class="menu-item <?= $current_page === 'admin_log' ? 'active' : '' ?>">
      <span class="menu-icon">📝</span>
      <span class="menu-text">Catatan Log</span>
    </a>
    <?php endif; ?>
    
    <!-- Permission-based menus HANYA untuk staff dengan permission -->
    <?php if (!$is_master): ?>
      <?php if (has_permission('manage_pasaran')): ?>
      <a href="admin_pasaran.php" class="menu-item <?= $current_page === 'admin_pasaran' ? 'active' : '' ?>">
        <span class="menu-icon">🏆</span>
        <span class="menu-text">Admin Pasaran</span>
        <span class="permission-badge">📋</span>
      </a>
      <?php endif; ?>
      
      <?php if (has_permission('view_logs')): ?>
      <a href="admin_log.php" class="menu-item <?= $current_page === 'admin_log' ? 'active' : '' ?>">
        <span class="menu-icon">📝</span>
        <span class="menu-text">Catatan Log</span>
        <span class="permission-badge">📋</span>
      </a>
      <?php endif; ?>
      
      <?php if (has_permission('manage_seo')): ?>
      <a href="admin_seo.php" class="menu-item <?= $current_page === 'admin_seo' ? 'active' : '' ?>">
        <span class="menu-icon">🔍</span>
        <span class="menu-text">SEO Settings</span>
        <span class="permission-badge">📋</span>
      </a>
      <?php endif; ?>
      
      <?php if (has_permission('view_users')): ?>
      <a href="admin_users.php" class="menu-item <?= $current_page === 'admin_users' ? 'active' : '' ?>" style="opacity: 0.7;">
        <span class="menu-icon">👥</span>
        <span class="menu-text">Lihat Users</span>
        <span class="permission-badge">📋</span>
      </a>
      <?php endif; ?>
    <?php endif; ?>
    
    <div class="menu-divider"></div>
    
    <a href="../" class="menu-item" target="_blank">
      <span class="menu-icon">🌐</span>
      <span class="menu-text">Lihat Website</span>
    </a>
    
    <a href="logout.php" class="menu-item logout">
      <span class="menu-icon">🚪</span>
      <span class="menu-text">Logout</span>
    </a>
  </nav>
</div>

<style>
.permission-badge {
  font-size: 10px;
  background: #22c55e;
  color: white;
  padding: 2px 4px;
  border-radius: 3px;
  margin-left: auto;
}

.role-badge {
  font-size: 10px;
  padding: 2px 6px;
  border-radius: 3px;
  font-weight: bold;
}

.role-badge.master {
  background: #dc2626;
  color: white;
}

.role-badge.staff {
  background: #059669;
  color: white;
}

.menu-divider {
  height: 1px;
  background: #e5e7eb;
  margin: 15px 0;
}
</style>