<?php
function get_website_setting($conn, $key, $default = '') {
    static $cache = [];
    
    if (!isset($cache[$key])) {
        $stmt = $conn->prepare("SELECT setting_value FROM website_settings WHERE setting_key = ?");
        $stmt->bind_param("s", $key);
        $stmt->execute();
        $result = $stmt->get_result()->fetch_assoc();
        $stmt->close();
        
        $cache[$key] = $result ? $result['setting_value'] : $default;
    }
    
    return $cache[$key];
}

// Load all settings at once for better performance
function get_all_website_settings($conn) {
    static $all_settings = null;
    
    if ($all_settings === null) {
        $all_settings = [];
        $result = $conn->query("SELECT setting_key, setting_value FROM website_settings");
        if ($result) {
            while ($row = $result->fetch_assoc()) {
                $all_settings[$row['setting_key']] = $row['setting_value'];
            }
        }
    }
    
    return $all_settings;
}
?>