<?php
include '../config.php';

// Cek duplikat dan log jika ada
$check = $conn->query("
    SELECT pasaran_id, DATE(tanggal) as tgl, periode, prize, nomor, COUNT(*) as jumlah
    FROM hasil 
    GROUP BY pasaran_id, DATE(tanggal), periode, prize, nomor
    HAVING COUNT(*) > 1
    ORDER BY tgl DESC
");

if ($check->num_rows > 0) {
    echo "⚠️ DUPLIKAT DITEMUKAN:\n";
    while ($row = $check->fetch_assoc()) {
        echo "Pasaran: {$row['pasaran_id']}, Tanggal: {$row['tgl']}, Prize: {$row['prize']}, Nomor: {$row['nomor']}, Jumlah: {$row['jumlah']}\n";
    }
} else {
    echo "✅ Tidak ada duplikat ditemukan\n";
}
?>